"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

Communicate from Twisted to Stackless
"""

import uthread

_CommChannel = None
_DisplayChannel = None

# Set up the communications channels
def SetupCommChannels():
    global _CommChannel, _DisplayChannel
    _CommChannel = uthread.Channel("CommChannel")
    _DisplayChannel = uthread.Channel("DisplayChannel")

# Retrieve the basic communications channel
def GetCommChannel():
    global _CommChannel
    return _CommChannel

# Retrieve the channel to talk with the display
def GetDisplayChannel():
    global _DisplayChannel
    return _DisplayChannel

# Send a message using the basic communications channel
def SendToComm(msg):
    global _CommChannel
    _CommChannel.send(msg)

# Send a message to the display
def SendToDisplay(msg):
    global _DisplayChannel
    _DisplayChannel.send(msg)
