"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

The ObjectBase class is the lowest level simulation
object.  It may be registered with the object databsae
to obtain a unique ID and handles messaging.
"""

import stackless
import tasklet

class ObjectBase(object):
    """Base class that handles messaging and database registration"""
    def __init__(self, name="", channel=None):
        self.__name = name
        self.__id = -1
        self.__channel = channel or stackless.channel()
        self.processMsgHandler = self.__DefaultMsgHandler
        self.__processMessages = False
        self.__msgTasklet = None
    
    # Properties
    
    def __GetName(self):
        return self.__name
    
    def __SetName(self, name):
        self.__name = name
    
    Name = property(__GetName, __SetName)
    
    def __GetID(self):
        return self.__id
    
    ID = property(__GetID)
    
    def __GetChannel(self):
        return self.__channel
    
    def __SetChannel(self, channel):
        self.__channel = channel
    
    Channel = property(__GetChannel, __SetChannel)
    
    # Public Methods
    
    def Send(self, msg):
        self.Channel.send(msg)
    
    # Protected Methods
    
    def _Register(self, id):
        self.__id = id
        self.__processMessages = True
        self.__msgTasklet = tasklet.newObjTasklet(self, "ObjectBase::ProcessMessage", self.__ProcessMessage)
    
    def _Unregister(self):
        self.__id = -1
        self.__processMessages = False
        if self.__msgTasklet:
            self.__msgTasklet.kill()
    
    # Private Methods
    
    def __ProcessMessage(self):
        while self.__processMessages:
            self.processMsgHandler(self.Channel.receive())
    
    def __DefaultMsgHandler(self, args):
        print self.__class__.__name__, "(" + self.Name + "):", args
    
    