"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

An object database allowing registration and lookup.
"""

from objectbase import ObjectBase

__NextObjID = 0
__ObjectListByID = {}

def Register(obj):
    """Register an object with the database"""
    global __NextObjID, __ObjectListByID
    
    if obj is None:
        assert False, "Cannot register a None object"
        return
    
    if obj in __ObjectListByID.values():
        assert False, "Object already registered"
        return
    
    if not(isinstance(obj, ObjectBase)):
        assert False, "Object is not an instance of ObjectBase"
        return
    
    __ObjectListByID[__NextObjID] = obj
    obj._Register(__NextObjID)
    __NextObjID += 1
    print obj.__class__.__name__, "(" + obj.Name + ")", "registered with ID", str(obj.ID)

def Unregister(id):
    """Unregister an object from the database given its ID"""
    global __ObjectListByID
    try:
        __ObjectListByID[id]._Unregister()
        del __ObjectListByID[id]
    except KeyError:
        assert False, "Unregistering an object that has not been properly registered"
        return

def UnregisterAll():
    """Unregister all objects in the database"""
    for id in __ObjectListByID.keys():
        Unregister(id)
        
def FindObjectByID(id):
    """Returns the object that matches the given ID"""
    global __ObjectListByID
    try:
        return __ObjectListByID[id]
    except KeyError:
        return None

def FindObjectByName(name):
    """Returns the object that matches the given name"""
    global __ObjectListByID
    for v in __ObjectListByID.values():
        if v.Name == name:
            return v
    
    return None

def NumObjects():
    """Returns the number of objects registered with the database"""
    global __ObjectListByID
    return len(__ObjectListByID)

def GetEnumerator():
    """Iterate through the object database"""
    global __ObjectListByID
    for o in __ObjectListByID.values():
        yield o
