"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

Sets up the simulation's zone and display and
provides the game loop.
"""

import zone
import display
import objectdb
import stackless
import uthread
import traceback
import tasklet

Running = True

# Start the simulation
def Startup(displayChannel, commChannel):
    displayChannel.send(("OPENWINDOW",))
    commChannel.send(("STARTUP",))
    stackless.schedule()

# Defines the thread that is launched by Twisted
def run(commChannel, displayChannel):
    global Running
    
    # Build the Zone
    obj = zone.Zone(commChannel)
    objectdb.Register(obj)

    # Build the display
    obj = display.Display(displayChannel)
    objectdb.Register(obj)
    
    # Allow the simulation to start up
    tasklet.new("StacklessThread::Run::Startup", Startup, displayChannel, commChannel)
    
    # Game loop
    while Running:
        uthread.RunNiceTasklets()
        
        if stackless.getruncount() > 1:
            done = False
            while not done:
                interruptedTasklet = stackless.run(10000000)
                if interruptedTasklet is None:
                    done = True
                else:
                    # Insert the tasklet back and we'll run the scheduler again.  We could do a
                    # interruptedTasklet.kill() instead but without knowing what this tasklet is
                    # is doing everything may be in a bad state if we allow another tasklet to
                    # run.
                    print "------"
                    print "Interrupted Tasklet Stacktrace (%s):" % interruptedTasklet.context
                    traceback.print_stack(interruptedTasklet.frame)
                    print "------"
                    interruptedTasklet.run()

        uthread.CheckSleepingTasklets()
 
    # Unregister all objects before we shut down
    objectdb.UnregisterAll()
    