"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

Provides the target the space ships chase after.
"""

from movingobject import MovingObject
import objectdb
import uthread
import random

class Target(MovingObject):
    """Randomly moving target for other objects to follow"""
    def __init__(self):
        super(Target, self).__init__("Target")
        self.updateHandler = self.__UpdateTarget
    
    # Private Methods
    
    def __UpdateTarget(self):
        while self.updatePos:
            zone = objectdb.FindObjectByName("Zone")
            if zone is not None:
                # Random position within the zone
                self.Position[0] = random.randint(0, zone.Size[0])
                self.Position[1] = random.randint(0, zone.Size[1])
                print "Updating Target position to", self.Position

            uthread.Sleep(random.randint(4, 10))
