"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

Provides context and parent class info for Stackless tasklets
Based on uthread.py by CCP and Richard Tew
"""

import stackless

class Tasklet(stackless.tasklet):
    pass

def new(context, func, *args, **kw):
    t = Tasklet(func)(*args, **kw)
    t.context = context
    t.parentObj = None
    return t

def newWithoutTheStars(context, func, args, kw):
    t = Tasklet(func)(*args, **kw)
    t.context = context
    t.parentObj = None
    return t

def newObjTasklet(parentObj, context, func, *args, **kw):
    t = new(context, func, *args, **kw)
    t.parentObj = parentObj
    return t

def newObjTaskletWithoutTheStars(parentObj, context, func, args, kw):
    t = newWithoutTheStars(context, func, *args, **kw)
    t.parentObj = parentObj
    return t
