"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

Utility functions to work with 2D vectors as lists
"""

import math

def magnitude(vec):
    return math.sqrt(vec[0] ** 2 + vec[1] ** 2)

def normalize(vec):
    d = magnitude(vec)
    vec[0] = vec[0] / d
    vec[1] = vec[1] / d
    return vec

def normalized(vec):
    d = magnitude(vec)
    return [vec[0] / d, vec[1] / d]
