"""
Stackless and Twisted Threaded Example
Copyright (C) 2007 David Wyand

Defines the web pages displayed using Twisted
"""

from twisted.web import resource, static, server
from twisted.internet import reactor
import comm

class HomePage(resource.Resource):
    """Main page listing all registered objects"""
    def render_GET(self, request):
        comm.SendToComm(("GETAIOBJECTS", self, request))
        return server.NOT_DONE_YET
    
    def ReceiveAIObjectList(self, targetPos, db, request):
        request.write("""
        <html>
        <head>
          <title>Twisted Stackless Example by David Wyand</title>
        </head>
        <SCRIPT TYPE="text/javascript">
        <!--
        function GoToTasklets() {
          this.location.href = "/tasklets";
        }
        //-->
        </SCRIPT>
        <body>
        """)
        
        request.write("<table><tr>")
        request.write("<td><FORM method='post'><INPUT TYPE=HIDDEN NAME=\"postingID\" value=\"quit\"><INPUT TYPE=SUBMIT VALUE=\"Quit\"></FORM></td>")
        request.write("<td><FORM method='post'><INPUT TYPE=HIDDEN NAME=\"postingID\" value=\"display\"><INPUT TYPE=SUBMIT VALUE=\"Open Display\"></FORM></td>")
        request.write("<td><FORM><INPUT TYPE=BUTTON OnClick=\"GoToTasklets()\" VALUE=\"Show Tasklets\"></FORM></td>")
        request.write("</tr></table>")
        
        posText = "%.3f, %.3f" % (targetPos[0], targetPos[1])
        request.write("<HR><p>Target position: " + posText + "</p>");
        
        request.write("""
        <table cellpadding=4>
          <tr bgcolor="#99CCFF">
            <th>Object ID</th>
            <th>Name</th>
            <th>Position</th>
          </tr>
        """)
        
        for key in db:
            (name, pos) = db[key]
            posText = "%.3f, %.3f" % (pos[0], pos[1])
            request.write("<tr><td>" + str(key) + "</td><td>" + str(name) + "</td><td>" + posText + "</td></tr>")
        
        request.write("""
        </table>
        </body>
        </html>
        """)
        
        request.finish()
    
    def render_POST(self, request):
        if "postingID" in request.args.keys():
            postType = request.args["postingID"][0]
            
            if postType == "quit":
                comm.SendToComm(("SHUTDOWN",))
                reactor.stop()
                
            elif postType == "display":
                comm.SendToDisplay(("OPENWINDOW",))
        
        request.redirect('/')
        return ""

class TaskletPage(resource.Resource):
    """Page listing all running tasklets"""
    def render_GET(self, request):
        comm.SendToComm(("GETTASKLETS", self, request))
        return server.NOT_DONE_YET
    
    def ReceiveTaskletList(self, taskletList, request):
        request.write("""
        <html>
        <head>
          <title>Twisted Stackless Example by David Wyand</title>
        </head>
        <SCRIPT TYPE="text/javascript">
        <!--
        function GoToHome() {
          this.location.href = "/";
        }
        //-->
        </SCRIPT>
        <body>
        """)
        
        request.write("<table><tr>")
        request.write("<td><FORM method='post'><INPUT TYPE=HIDDEN NAME=\"postingID\" value=\"quit\"><INPUT TYPE=SUBMIT VALUE=\"Quit\"></FORM></td>")
        request.write("<td><FORM method='post'><INPUT TYPE=HIDDEN NAME=\"postingID\" value=\"display\"><INPUT TYPE=SUBMIT VALUE=\"Open Display\"></FORM></td>")
        request.write("<td><FORM><INPUT TYPE=BUTTON OnClick=\"GoToHome()\" VALUE=\"Show Objects\"></FORM></td>")
        request.write("</tr></table>")
        
        request.write("""
        <HR><p>Tasklets as viewed from the garbage collector:</p>
        <table cellpadding=4>
          <tr bgcolor="#99CCFF">
            <th>No.</th>
            <th>Parent</th>
            <th>Context</th>
            <th>Class</th>
            <th>ID</th>
            <th>Blocked</th>
            <th>Is Current</th>
            <th>Is Main</th>
            <th>Thread ID</th>
          </tr>
        """)
        
        counter = 1
        taskletList.sort()
        for t in taskletList:
            if t[7]:
                # Main tasklet
                request.write('<tr bgcolor="DDDDDD">')
            elif t[6]:
                # Current tasklet
                request.write('<tr bgcolor="FFFFAA">')
            else:
                request.write("<tr>")
                
            request.write("<td>" + str(counter))
            for i in range(1, 8):
                request.write("</td><td>" + str(t[i]))
            request.write("</td><td>" + str(t[0]))
            request.write("</td></tr>")
            counter += 1
        
        request.write("""
        </table>
        </body>
        </html>
        """)
        
        request.finish()
    
    def render_POST(self, request):
        if "postingID" in request.args.keys():
            postType = request.args["postingID"][0]
            
            if postType == "quit":
                comm.SendToComm(("SHUTDOWN",))
                reactor.stop()
                
            elif postType == "display":
                comm.SendToDisplay(("OPENWINDOW",))
        
        request.redirect('/tasklets')
        return ""

def Setup():
    root = resource.Resource()
    root.putChild('', HomePage())
    root.putChild('tasklets', TaskletPage())
    
    site = server.Site(root)
    reactor.listenTCP(8001, site)
