#pragma warning ( disable: 4786 )
#include <vector>
#include <map>
#include <cmath>

#include "LWGlobal.h"

#include "DTSLWMesh.h"
#include "LWSupport/objectdb.h"

namespace DTS
{

	// -----------------------------------------------------------------------
	//  Imports a Lighwave Mesh
	// -----------------------------------------------------------------------

	//+++ CLWMesh::CLWMesh (lwMesh * mesh, int rootBone, float scaleFactor, bool WithMaterials) : Mesh (Mesh::T_Standard) <- Original Version
	CLWMesh::CLWMesh (LWItemID itemID, int rootBone, float scaleFactor, bool WithMaterials) : Mesh (Mesh::T_Standard)
	{
		ObjectDB		*odb = NULL;
		char			tempbuffer[512];

		int v, n ;

		//*** TODO: Find out what materialIndex refers to.
		//+++ int materialIndex = msMesh_GetMaterialIndex(mesh) ;
		int materialIndex = 0;

		//*** Build the database for this object
		odb = getObjectDB( itemID, CLWGlobal::global );
		if ( !odb ) {
			//*** TODO: Need to handle this error better
			CLWGlobal::msg->error( "Couldn't allocate object database for", CLWGlobal::iteminfo->name( itemID ));
			return;
		}

sprintf(tempbuffer,"%i",odb->npoints);
CLWGlobal::msg->info("Number of points in object",tempbuffer);

		//*** Import vertex position and texture data
		//+++ for (v = 0 ; v < msMesh_GetVertexCount(mesh) ; v++)
		for (v = 0 ; v < odb->npoints ; v++)
		{
			//+++ msVertex * vertex = msMesh_GetVertexAt(mesh, v) ;
			//+++ msVec3     vector ;
         
			//+++ msVertex_GetVertex (vertex, vector) ;

			//+++ vector[0] *= scaleFactor ;
			//+++ vector[1] *= scaleFactor ;
			//+++ vector[2] *= scaleFactor ;

			float vector[3];	//*** The coordinates of a single point

			//*** Obtain the coordinates of a single point.  The position is in the
			//*** form of pos[a][b] where a=0 for the initial position and
			//*** a=1 for the transformed position at the current frame;
			//*** b=0..2 for the x,y,z of the point.
			//*** NOTE: For this to work, the bounding box parameters in Layout must
			//*** be set so that all points for the current frame are displayed.
			//*** (Perhaps only required when obtaining trandformed position??)
			vector[0] = (odb->pt[ v ].pos[ 0 ][ 0 ]) * scaleFactor;
			vector[1] = (odb->pt[ v ].pos[ 0 ][ 1 ]) * scaleFactor;
			vector[2] = (odb->pt[ v ].pos[ 0 ][ 2 ]) * scaleFactor;
         
			//*** TODO: The intial MilkShape code from which this derived from only
			//*** allows for a single bone per vertex (as MS only allows
			//*** that many).  LW supports many bones per vertex, and this
			//*** will need to be coded here.  For now, don't deal with bones
			//*** at all and default to the 'rootBone'.  Later, add in support
			//*** for vmapped bones.
			vindex.push_back(verts.size());
			//+++ int bone = msVertex_GetBoneIndex (vertex);
			//+++ vbone.push_back(getVertexBone((bone >= 0)? bone: rootBone));
			vbone.push_back(getVertexBone(rootBone));
			vweight.push_back(1.0);

			//*** The LWPoint class takes care of axis conversion
			//+++ verts.push_back (MilkshapePoint(vector)) ;
			verts.push_back (LWPoint(vector)) ;

			//*** Build texture coordinates
			//*** TODO: for now, set them to zero.  Will need to pull the UV
			//*** coordinates from the vmap(s) for the vertex.
			//+++ msVertex_GetTexCoords (vertex, vector) ;
			//+++ tverts.push_back (Point2D(vector[0], vector[1])) ;
			tverts.push_back (Point2D(0.0f, 0.0f)) ;
		}

		//*** Adjust our type. We default to a rigid mesh, but if the mesh
		//*** is attached to more than one bone, we need to output as a skin
		//*** mesh. Node index is managed by the getVertexBone method.
		if (nodeIndex.size() > 1)
			setType(T_Skin);

/*+++
		// Import normals (into a temporary vector)
      
		std::vector<Point> msNormals ;

		for (v = 0 ; v < msMesh_GetVertexNormalCount(mesh) ; v++)
		{
			msVec3 vector ;         
			msMesh_GetVertexNormalAt (mesh, v, vector) ;
			msNormals.push_back (MilkshapePoint(vector)) ;
		}
+++*/

		// Import primitives (as single triangles for now)
		// While we're at it, use the triangle data to get per-vertex normals
      
		std::vector<bool> vertexNormalFound (verts.size(), false) ;    
		normals.assign  (verts.size(), Point()) ;
		enormals.assign (verts.size(), '\0') ;

sprintf(tempbuffer,"%i",odb->npolygons);
CLWGlobal::msg->info("Number of polygons in object",tempbuffer);

		//+++ for (v = 0 ; v < msMesh_GetTriangleCount(mesh) ; v++)
		for (v = 0 ; v < odb->npolygons ; v++)
		{
			//+++ msTriangle * triangle = msMesh_GetTriangleAt(mesh, v) ;
			//+++ word         ivertexes[3] ;
			//+++ word         inormals[3] ;
			Primitive    myTriangle ;
         
			//+++ msTriangle_GetVertexIndices (triangle, ivertexes) ;
			//+++ msTriangle_GetNormalIndices (triangle, inormals) ;

/*+++
			// Transform milkshape per-triangle normals to V12 per-vertex normals
			// There could be many normals per vertex, interpolate them

			for (n = 0 ; n < 3 ; n++)
			{
				if (!vertexNormalFound[ivertexes[n]])
				{
					vertexNormalFound[ivertexes[n]] = true ;
					normals[ivertexes[n]]  = msNormals[inormals[n]] ;
					enormals[ivertexes[n]] = encodeNormal(msNormals[inormals[n]]) ;
				}
				else
				{
					Point midpoint = (normals[ivertexes[n]] + msNormals[inormals[n]]) / 2.0f ;
					midpoint.normalize() ;
					normals[ivertexes[n]]  = midpoint ;
					enormals[ivertexes[n]] = encodeNormal(midpoint) ;
				}
			}
+++*/
			//*** Store the normals for each vertex in a polygon
			//*** TODO: Do this section based on above MS information!!
			for (n = 0 ; n < 3 ; n++)
			{
				normals[odb->pol[v].v[n].index] = Point(odb->pol[v].v[n].norm[0][0], odb->pol[v].v[n].norm[0][1], odb->pol[v].v[n].norm[0][2]);
				enormals[odb->pol[v].v[n].index] = encodeNormal(Point(odb->pol[v].v[n].norm[0][0], odb->pol[v].v[n].norm[0][1], odb->pol[v].v[n].norm[0][2]));
			}

			//*** Create a triangle primitive for this triangle
			myTriangle.firstElement = indices.size() ;
			myTriangle.numElements  = 3 ;
			myTriangle.type         = Primitive::Strip | Primitive::Indexed ;

			if (WithMaterials && materialIndex >= 0)
				myTriangle.type |= materialIndex ;
			else
				myTriangle.type |= Primitive::NoMaterial ;

			//+++ indices.push_back  (ivertexes[2]) ;
			//+++ indices.push_back  (ivertexes[1]) ;
			//+++ indices.push_back  (ivertexes[0]) ;
			indices.push_back  (odb->pol[v].v[2].index) ;
			indices.push_back  (odb->pol[v].v[1].index) ;
			indices.push_back  (odb->pol[v].v[0].index) ;
         
			primitives.push_back (myTriangle) ;
		}
      
		// Other stuff we don't support
      
		setFrames(1) ;
		setParent(-1) ;

		calculateBounds() ;
		calculateCenter() ;
		calculateRadius() ;

		//*** Release the object database pointer
		freeObjectDB( odb );

CLWGlobal::msg->info("Mesh complete for",CLWGlobal::iteminfo->name( itemID ));
	}
}