/*	DTSLWMESH.H
**
**	Defines the CLWMesh class and support structures to export a DTS model.
**	This is based on the work by Garage Games' Milkshape exporter.
**
**	Revision History:
**	February 11, 2002	David Wyand		Created file based on DTSMilkshapeMesh.h
*/

#ifndef __DTSLWMESH_H_
#define __DTSLWMESH_H_

#include <lwserver.h>
#include <lwrender.h>

#include "dtsSDK/DTSShape.h"
#include "dtsSDK/DTSQuaternion.h"

#include "LWData.h"

//#include "msLib.h"

namespace DTS
{
	//*** Defines a point imported from Lightwave coordinates

	struct LWPoint : public Point
	{
		LWPoint(const float p[3]) : Point(p[0], p[2], p[1]) {}
	};

	//*** Defines a quaternion imported from Lightwave angles

	struct LWQuaternion : public Quaternion
	{
		// Torque uses column vectors which means we need to flip
		// the rotations
//		LWQuaternion(const float p[3]) : Quaternion (p[0], -p[2], p[1]) {}
//		LWQuaternion(const float p[3]) : Quaternion (p[1], -p[2], p[0]) {} // Was prior to May 1
		LWQuaternion(const float p[3]) : Quaternion (p[1], p[2], p[0]) {}
	};

	//*** Defines a Mesh imported from Lightwave

	class CLWMesh : public Mesh
	{
	public:
		//*** Create a standard mesh from a Lightwave object
		//+++ CLWMesh (lwMesh *, int rootBone, float scaleFactor, bool WithMaterials) ; <- Original version
//		CLWMesh (CLWData* instdata, LWItemID itemID, int rootBone, float scaleFactor, bool WithMaterials) ;
		CLWMesh (CLWData* instdata, LWItemID itemID, int rootBone) ;
	};

}

#endif // __DTSLWMESH_H_
