/*	DTSLWSHAPE.H
**
**	Defines the CLWShape class to export a DTS model.  This is based on the work
**	by Garage Games' Milkshape exporter.
**
**	Revision History:
**	February 11, 2002	David Wyand		Created file based on DTSMilkshapeShape.h
*/

#ifndef __DTSLWSHAPE_H_
#define __DTSLWSHAPE_H_

#include "dtsSDK/DTSShape.h"
#include "LWData.h"

namespace DTS
{

	class CLWShape : public Shape
	{
	public:

		//*** Stores all the configuration data for the Lightwave constructor

		struct ImportConfig
		{
			ImportConfig() ;

			bool        withMaterials ;
			float       scaleFactor ;
			int         minimumSize ;
			int         collisionType ;
			int         collisionMesh ;
			float       collisionComplexity ;
			bool        collisionVisible ;
			bool        animation ;
			int         animationFPS ;
			bool        animationCyclic ;

			struct Sequence
			{
				std::string name;
				int start;
				int end;
				bool cyclic;
				int fps;
			};
			std::vector<Sequence> sequence;

			void reset();
		} ;

		//*** Import a Lightwave mesh
		//+++ CLWShape (struct lwModel *, ImportConfig) ; 
//		CLWShape (CLWData* instdata, ImportConfig) ; 
		CLWShape (CLWData* instdata) ; 

	};

}

#endif //__DTSLWSHAPE_H_