/*	DEBUG.CPP
**
**	Supports the CDebug class
**
**	Revision History:
**	February 28, 2002	David Wyand		Created file
*/

//*** Includes
#include "LWGlobal.h"
#include "Debug.h"

//*** Constructor
CDebug::CDebug()
{
}

//*** Open the file
void CDebug::OpenFile(char* filename)
{
	//std::ofstream out (filename) ;

	file.open(filename);

	if (!file)
	{
		CLWGlobal::msg->error("Error openning Debug file for writing.",filename);
		return;
	}
}

//*** Close the file
void CDebug::CloseFile()
{
	file.close();
}

//*** Write out a string
void CDebug::Write(char* text)
{
	if(file)
	{
		file << text << "\n";
	}
}

//*** Write out a string in column 1
void CDebug::WriteLabel(char* text)
{
	if(file)
	{
		file << text;
	}
}

//*** Write out data for Buffer32
void CDebug::Write(int val)
{
	if(file)
	{
		file << ",Buffer32," << val << "\n";
	}
}

//*** Write out data for Buffer16
void CDebug::Write(short val)
{
	if(file)
	{
		file << ",Buffer16," << val << "\n";
	}
}

//*** Write out data for Buffer8
void CDebug::Write(char val)
{
	if(file)
	{
		file << ",Buffer8," << (int) val << "\n";
	}
}

std::ofstream CDebug::file;
