/*	GUIANIMCUSTOMOBJ.CPP
**
**	Supports the CGUIAnimCustomObj functions
**
**	Revision History:
**	April 9, 2002		David Wyand		Created file
*/

//*** Includes
#include "GUIAnimCustomObj.h"

//*** Prototypes
static void TextJustificationPopupEvent( LWControl *ectl, void *edata );
static void TextPosEditEvent( LWControl *ectl, void *edata );

static void PanelUserCloseCallback( LWPanelID panel, void *edata );

//*** Globals
const char* ACOPanelTitleText[] = {"",(char*)NULL};
const char* TextJustificationPopupType[] =
{
	"Left","Centre","Right",(char*)NULL
};


//*** Constructor
CGUIAnimCustomObj::CGUIAnimCustomObj()
{
	m_InstData = (CLWACOData*) NULL;
}

//*** Destructor
CGUIAnimCustomObj::~CGUIAnimCustomObj()
{
}

//*** Create the controls
bool CGUIAnimCustomObj::CreateAnimCustomObj(CLWACOData* inst, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height)
{
	LWPanControlDesc desc;
	static LWValue ival={LWT_INTEGER},ivecval={LWT_VINT},fval={LWT_FLOAT},fvecval={LWT_VFLOAT},sval={LWT_STRING};
	LWControl* PanelTitle;

	if(inst)
	{
		m_InstData = inst;
	} else
	{
		return false;
	}

	m_Panel = panel;
	m_Panf = panf;

	PAN_SETDATA( panf, panel, this );
	panf->set(panel, PAN_USERCLOSE, PanelUserCloseCallback);

	//*** Build the controls
	PanelTitle = TEXT_CTL( panf, panel, "DTS Animation Sequence Custom Object", ACOPanelTitleText );

	m_TextJustificationPopup = POPUP_CTL( panf, panel, "Anim Sequence Title Justification:", &(TextJustificationPopupType[0]) );
	CON_SETEVENT( m_TextJustificationPopup, TextJustificationPopupEvent, this );

	m_TextPosEdit = FLOAT_CTL( panf, panel, "Text Position:" );
	CON_SETEVENT( m_TextPosEdit, TextPosEditEvent, this );

	//*** Setup the values of the controls
	SET_INT( m_TextJustificationPopup, m_InstData->m_nTextJustification );
	SET_FLOAT( m_TextPosEdit, m_InstData->m_fTextPos );

	return true;
}

//*** Event for the TextJustificationPopup control
static void TextJustificationPopupEvent( LWControl *ectl, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	int value;
	CGUIAnimCustomObj* data = (CGUIAnimCustomObj*)edata;

	GET_INT( ectl, value);

	//*** Store the value
	data->m_InstData->m_nTextJustification = value;

}

//*** Event for the TextPosEdit control
static void TextPosEditEvent( LWControl *ectl, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	double value;
	CGUIAnimCustomObj* data = (CGUIAnimCustomObj*)edata;

	GET_FLOAT( ectl, value);

	//*** Store the value
	data->m_InstData->m_fTextPos = (float) value;

}

//*** Panel user close callback
static void PanelUserCloseCallback( LWPanelID panel, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	CGUIAnimCustomObj* data = (CGUIAnimCustomObj*)edata;

}