/*	GUIEXPORTSHADER.CPP
**
**	Supports the CGUIExportShader functions
**
**	Revision History:
**	March 29, 2002		David Wyand		Created file
*/

//*** Includes
#include "GUIExportShader.h"

//*** Prototypes
static void TransparentTypePopupEvent( LWControl *ectl, void *edata );
static void NoMipMapChoiceEvent( LWControl *ectl, void *edata );
static void MipMapZeroBorderChoiceEvent( LWControl *ectl, void *edata );

static void PanelUserCloseCallback( LWPanelID panel, void *edata );

//*** Globals
const char* ShaderPanelTitleText[] = {"",(char*)NULL};
const char* TransparentTypePopupType[] =
{
	"Normal","Additive","Subtractive",(char*)NULL
};


//*** Constructor
CGUIExportShader::CGUIExportShader()
{
	m_InstData = (CLWESData*) NULL;
}

//*** Destructor
CGUIExportShader::~CGUIExportShader()
{
}

//*** Create the controls
bool CGUIExportShader::CreateExportShader(CLWESData* inst, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height)
{
	LWPanControlDesc desc;
	static LWValue ival={LWT_INTEGER},ivecval={LWT_VINT},fval={LWT_FLOAT},fvecval={LWT_VFLOAT},sval={LWT_STRING};
	LWControl* PanelTitle;

	if(inst)
	{
		m_InstData = inst;
	} else
	{
		return false;
	}

	m_Panel = panel;
	m_Panf = panf;

	PAN_SETDATA( panf, panel, this );
	panf->set(panel, PAN_USERCLOSE, PanelUserCloseCallback);

	//*** Build the controls
	PanelTitle = TEXT_CTL( panf, panel, "DTS Material Attributes", ShaderPanelTitleText );

	m_TransparentTypePopup = POPUP_CTL( panf, panel, "Transparency Type:", &(TransparentTypePopupType[0]) );
	CON_SETEVENT( m_TransparentTypePopup, TransparentTypePopupEvent, this );

	m_NoMipMapChoice = BOOL_CTL( panf, panel, "Don't generate mip maps" );
	CON_SETEVENT( m_NoMipMapChoice, NoMipMapChoiceEvent, this );

	m_MipMapZeroBorderChoice = BOOL_CTL( panf, panel, "Don't generate mip map borders" );
	CON_SETEVENT( m_MipMapZeroBorderChoice, MipMapZeroBorderChoiceEvent, this );

	//*** Setup the values of the controls
	SET_INT( m_TransparentTypePopup, m_InstData->m_nTransparentType );
	SET_INT( m_NoMipMapChoice, m_InstData->m_nNoMipMap );
	SET_INT( m_MipMapZeroBorderChoice, m_InstData->m_nMipMapZeroBorder );

	return true;
}

//*** Event for the TransparentTypePopup control
static void TransparentTypePopupEvent( LWControl *ectl, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	int value;
	CGUIExportShader* data = (CGUIExportShader*)edata;

	GET_INT( ectl, value);

	//*** Store the value
	data->m_InstData->m_nTransparentType = value;

}

//*** Event for the NoMipMapChoice control
static void NoMipMapChoiceEvent( LWControl *ectl, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	int value;
	CGUIExportShader* data = (CGUIExportShader*)edata;

	GET_INT( ectl, value);

	//*** Store the value
	data->m_InstData->m_nNoMipMap = value;

}

//*** Event for the m_MipMapZeroBorderChoice control
static void MipMapZeroBorderChoiceEvent( LWControl *ectl, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	int value;
	CGUIExportShader* data = (CGUIExportShader*)edata;

	GET_INT( ectl, value);

	//*** Store the value
	data->m_InstData->m_nMipMapZeroBorder = value;

}

//*** Panel user close callback
static void PanelUserCloseCallback( LWPanelID panel, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	CGUIExportShader* data = (CGUIExportShader*)edata;

}