/*	GUIEXPORTSHADER.H
**
**	Defines the CGUIExportShader class to build the GUI for the material shader
**
**	Revision History:
**	March 19, 2002		David Wyand		Created file
*/

#ifndef __GUIEXPORTSHADER_H__
#define __GUIEXPORTSHADER_H__

//*** Includes
#include <lwserver.h>
#include <lwrender.h>
#include <lwpanel.h>
#include "LWESData.h"

//*** Define the CGUIViewNodes class
class CGUIExportShader
{
	//*** Functions
public:
	CGUIExportShader();
	virtual ~CGUIExportShader();

	bool CreateExportShader(CLWESData* inst, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height);

	//*** Variables
public:
	LWPanelID						m_Panel;
	LWPanelFuncs*					m_Panf;
	CLWESData*						m_InstData;

	LWControl*						m_TransparentTypePopup;
	LWControl*						m_NoMipMapChoice;
	LWControl*						m_MipMapZeroBorderChoice;
};


#endif // __GUIEXPORTSHADER_H__
