/*	GUIMESHSELECTOR.CPP
**
**	Supports the CGUIMeshSelector functions
**
**	Revision History:
**	February 11, 2002	David Wyand		Created file
*/

//*** Includes
#include <windows.h>

#pragma warning ( disable: 4786 )

#include <fstream> 

#include "DTSLWShape.h"
#include "GUIMeshSelector.h"


//*** Prototypes
static int TreeCount( void* data, void* vnode );
static void* TreeChild( void *vroot, void *vnode, int i );
static char* TreeInfo( void* data, void* vnode, int* flags );
static void TreeEvent( LWControl *ectl, void *edata );
static void ExportButtonEvent( LWControl *ectl, void *edata );
static int MeshListBoxCount( void *userdata );
static char* MeshListBoxName( void *userdata, int index );
static void MeshListBoxEvent( LWControl *ectl, void *edata );

//*** Constructor
CGUIMeshSelector::CGUIMeshSelector()
{
	m_Global = NULL;
	m_nNodes = 0;
	m_nItemList = 0;

	//*** Setup the root node (TEMP)
//	MeshSelectionNode* node = new MeshSelectionNode;
//	node->m_ID = (void*) 0;
//	strcpy(node->m_Name,"Root");
//	node->m_nChildren = 0;
//	node->m_Flags = 0;
//
//	m_Nodes.push_back(node);

}

//*** Destructor
CGUIMeshSelector::~CGUIMeshSelector()
{
	vector<MeshSelectionNode*>::iterator itor;

	//*** Delete the MeshSelectionNode instances.  Only need to do this for the m_ItemList
	//*** as m_Nodes points to the same instances.
	for(itor = m_ItemList.begin(); itor != m_ItemList.end(); ++itor)
	{
		delete (*itor);
	}

	m_ItemList.clear();
	m_Nodes.clear();

}

//*** Create the Mesh Selector
bool CGUIMeshSelector::CreateMeshSelector(CLWData* inst, GlobalFunc* global, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height)
{
	LWPanControlDesc desc;
	static LWValue ival={LWT_INTEGER},ivecval={LWT_VINT},fval={LWT_FLOAT},fvecval={LWT_VFLOAT},sval={LWT_STRING};

	if(global)
	{
		m_Global = global;
	} else
	{
		return false;
	}

	if(inst)
	{
		m_InstData = inst;
	} else
	{
		return false;
	}

	//*** Populate the tree
	InitPopulation();

	//*** Build the controls
//	m_TreeControl = TREE_CTL( panf, panel, "Test", width, height, TreeInfo, TreeCount, TreeChild );
//	CON_SETEVENT( m_TreeControl, TreeEvent, this );

	m_MeshListBox = LISTBOX_CTL(panf, panel, "Mesh List", width, 5, MeshListBoxName, MeshListBoxCount);
	CON_SETEVENT( m_MeshListBox, MeshListBoxEvent, this );

	m_ExportButton = BUTTON_CTL( panf, panel, "Export DTS File" );
	CON_SETEVENT( m_ExportButton, ExportButtonEvent, this );

	return true;
}

//*** Refresh the mesh list
void CGUIMeshSelector::RefreshMeshList()
{
}

//*** Initalize the population of the mesh list
bool CGUIMeshSelector::InitPopulation()
{
	LWItemID id;

	//*** Obtain item and object info global functions
	m_ItemInfo = (LWItemInfo*) (*m_Global)( LWITEMINFO_GLOBAL, GFUSE_TRANSIENT );
	m_ObjInfo  = (LWObjectInfo*) (*m_Global)( LWOBJECTINFO_GLOBAL, GFUSE_TRANSIENT );

	if(!m_ItemInfo || !m_ObjInfo)
	{
		return false;
	}

	id = m_ItemInfo->first( LWI_OBJECT, NULL );
	while(id != LWITEM_NULL)
	{
		//*** Only process if this object is at the top level (no parent).  Otherwise,
		//*** children objects will also be added to the root level.
		if(m_ItemInfo->parent(id) == LWITEM_NULL)
		{
			ProcessObject(id, NULL);
		}

		id = m_ItemInfo->next(id);
	}

	return true;
}

//*** Process an object
void CGUIMeshSelector::ProcessObject(LWItemID id, MeshSelectionNode* parent)
{
	LWItemID	childID, prevID;
	vector<MeshSelectionNode*>::iterator itor;

	MeshSelectionNode* node = new MeshSelectionNode;
	node->m_ID = (void*) 0;
	strncpy(node->m_Name,m_ItemInfo->name(id), MAX_NODE_NAME);
	node->m_nChildren = 0;
	node->m_Flags = 0;

	if(parent == NULL)
	{
		m_Nodes.push_back(node);
		++m_nNodes;
		m_ItemList.push_back(node);
		++m_nItemList;

	} else
	{
		parent->m_Child.push_back(node);
		++(parent->m_nChildren);
		m_ItemList.push_back(node);
		++m_nItemList;
	}

	//*** Process any children
	childID = m_ItemInfo->firstChild(id);
	while(childID != LWITEM_NULL)
	{
		//*** Check if this object has already been processed.  If so
		//*** then skip it
		bool Foundit = false;
		for(itor = m_ItemList.begin(); itor != m_ItemList.end(); ++itor)
		{
			if( (*itor)->m_ID == childID)
			{
				Foundit = true;
			}
		}
		if(Foundit == false)
		{
			ProcessObject(childID, node);
		}

		prevID = childID;
		childID = m_ItemInfo->nextChild(id, prevID);
	}
}


//************
//*** Functions for the tree list
//************

//static 
int TreeCount( void* vdata, void* vnode )
{
	MeshSelectionNode* node = (MeshSelectionNode*) vnode;
	CGUIMeshSelector* data = (CGUIMeshSelector*) vdata;

	if ( node )
	{
		return node->m_nChildren;
	} else
	{
		//return 1;
		return data->m_nNodes;
	}
}


static void* TreeChild( void *vdata, void *vnode, int i )
{
	MeshSelectionNode* node = (MeshSelectionNode*)vnode;
	CGUIMeshSelector* data = (CGUIMeshSelector*)vdata;

	if ( node )
		return (void*) (node->m_Child[ i ]);
	else
		return (void*) (data->m_Nodes[ i ]);
}


static char* TreeInfo( void* vdata, void* vnode, int* flags )
{
	MeshSelectionNode* node = (MeshSelectionNode*)vnode;
	CGUIMeshSelector* data = (CGUIMeshSelector*)vdata;

	if ( *flags )
		node->m_Flags = *flags;
	else
		*flags = node->m_Flags;

	if(node)
	{
		return node->m_Name;
	} else
	{
		return "";
	}
}


static void TreeEvent( LWControl *ectl, void *edata )
{
 	CGUIMeshSelector* data = (CGUIMeshSelector*)edata;
	LWValue ival = { LWT_INTEGER };
	MeshSelectionNode *sel;

	ectl->get( ectl, CTL_VALUE, &ival );
	sel = ( MeshSelectionNode * ) ival.intv.value;
}


//*** Functions for the export mesh button
static void ExportButtonEvent( LWControl *ectl, void *edata )
{
 	CGUIMeshSelector* data = (CGUIMeshSelector*)edata;
	LWValue ival = { LWT_INTEGER };

	CGUIMeshSelector* instdata = (CGUIMeshSelector*) edata;
	int myvalue;

	GET_INT(data->m_MeshListBox, myvalue);

//	char buf[128];
//	sprintf(buf,"%i",myvalue);
//	::MessageBox(NULL,buf,"Info",MB_OK);

	char szFile[512] = "C:/torque/example/fps/data/shapes/LWTest/TestObject.dts" ;
	std::ofstream file (szFile, std::ios::binary | std::ios::trunc | std::ios::out) ;

	if (!file)
	{
		MessageBox (NULL, "Error creating the file.",
					"Torque Game Engine (DTS) Exporter", MB_ICONSTOP | MB_OK) ;
	} else
	{

		DTS::CLWShape::ImportConfig config;
		DTS::CLWShape shape(instdata->m_InstData, config) ;
		shape.save(file) ;
	}
}


//*** Functions for the Mesh List Box
static int MeshListBoxCount( void *userdata )
{
	if(userdata)
	{
	 	CGUIMeshSelector* data = (CGUIMeshSelector*)userdata;

		return data->m_nItemList;
	} else
	{
		return 0;
	}
}

static char* MeshListBoxName( void *userdata, int index )
{
	if(userdata)
	{
 		CGUIMeshSelector* data = (CGUIMeshSelector*)userdata;

		return data->m_ItemList[index]->m_Name;
	} else
	{
		return NULL;
	}
}

static void MeshListBoxEvent( LWControl *ectl, void *edata )
{
 	CGUIMeshSelector* data = (CGUIMeshSelector*)edata;
	LWValue ival = { LWT_INTEGER };
	MeshSelectionNode *sel;

	ectl->get( ectl, CTL_VALUE, &ival );
	sel = ( MeshSelectionNode * ) ival.intv.value;
}
