/*	GUIMESHSELECTOR.H
**
**	Defines the CGUIMeshSelector class to build the GUI for the mesh selection tree
**
**	Revision History:
**	February 11, 2002	David Wyand		Created file
*/

#ifndef __MESHSELECTOR_H__
#define __MESHSELECTOR_H__

//*** Includes
#include <vector>
#include <lwserver.h>
#include <lwrender.h>
#include <lwpanel.h>
#include "LWData.h"

//*** Defines
#define MAX_NODE_NAME	32

using namespace std;

//*** Define a structure for each node in the GUI tree
typedef struct st_MeshSelectionNode {
	LWItemID						m_ID;					// LW object ID
	char							m_Name[MAX_NODE_NAME];	// Custom name for this object
	vector<st_MeshSelectionNode*>	m_Child;				// Children list
	int								m_nChildren;			// Number of children
	int								m_Flags;				// LW flags
} MeshSelectionNode;

//*** Define the CGUIMeshSelector class
class CGUIMeshSelector
{
	//*** Functions
public:
	CGUIMeshSelector();
	virtual ~CGUIMeshSelector();

	bool CreateMeshSelector(CLWData* inst, GlobalFunc* global, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height);
	void RefreshMeshList();

protected:
	bool InitPopulation();
	void ProcessObject(LWItemID id, MeshSelectionNode* parent);

	//*** Variables
public:
	vector<MeshSelectionNode*>		m_Nodes;
	int								m_nNodes;		// Number of high-level nodes
	vector<MeshSelectionNode*>		m_ItemList;		// Absolute list of items already added
	int								m_nItemList;	// Number of absolute list items
	LWControl*						m_TreeControl;
	LWControl*						m_MeshListBox;
	CLWData*						m_InstData;

protected:
	GlobalFunc*						m_Global;
	LWItemInfo*						m_ItemInfo;
	LWObjectInfo*					m_ObjInfo;
	LWControl*						m_ExportButton;
};

#endif // __MESHSELECTOR_H__
