/*	GUIMESHSELECTOR.H
**
**	Defines the CGUIMeshSelector class to build the GUI for the mesh selection tree
**
**	Revision History:
**	February 11, 2002	David Wyand		Created file
**	April 4, 2002		David Wyand		Added support for the Animation Tab
*/

#ifndef __MESHSELECTOR_H__
#define __MESHSELECTOR_H__

//*** Includes
#include <vector>
#include <lwserver.h>
#include <lwrender.h>
#include <lwpanel.h>
#include "LWData.h"

//*** Defines
#define MAX_NODE_NAME	256

using namespace std;

//*** Define a structure for each node in the GUI tree
typedef struct st_MeshSelectionNode {
	LWItemID						m_ID;					// LW object ID
	char							m_szName[MAX_NODE_NAME];	// LW name for this object
	char							m_szDTSName[MAX_NODE_NAME];	// Custom name for this object
	vector<st_MeshSelectionNode*>	m_pChild;				// Children list
	int								m_nChildren;			// Number of children
	int								m_nFlags;				// LW flags
	int								m_nExportType;			// How to export 0=None, 1=Mesh, 2=Collision
} MeshSelectionNode;

//*** Define the CGUIMeshSelector class
class CGUIMeshSelector
{
	//*** Functions
public:
	CGUIMeshSelector();
	virtual ~CGUIMeshSelector();

	bool CreateMeshSelector(CLWData* inst, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height);
	void RefreshMeshList();

	void RefreshAnimList();

	void SetGlobalCanvas(DrMode mode);
	void SetAnimationCanvas(DrMode mode);
	void SetAdvancedCanvas(DrMode mode);

protected:
	bool InitPopulation();
	void ProcessObject(LWItemID id);

	//*** Variables
public:
	LWPanelID						m_Panel;
	LWPanelFuncs*					m_Panf;

//	vector<MeshSelectionNode*>		m_ItemList;		// Absolute list of items already added
	LWControl*						m_MeshListBox;
	LWControl*						m_LWNameEdit;
	LWControl*						m_DTSNameEdit;
	LWControl*						m_ExportTypePopup;
	LWControl*						m_GlobalRotationPopup;
	LWControl*						m_EncodedNormalsPopup;
	LWControl*						m_GlobalBorder0;
	LWControl*						m_GlobalBorder0b;

	LWControl*						m_GlobalTabChoice;
	LWControl*						m_TabCanvas;

	// Global tab controls
	LWControl*						m_SaveAs;
	LWControl*						m_ScaleFactorEdit;
	LWControl*						m_MinimunVisibleSizeEdit;
	LWControl*						m_CollisionTypeChoice;
	LWControl*						m_CollisionVisibleChoice;
	LWControl*						m_CollisionComplexityEdit;
	LWControl*						m_ExportMaterialsChoice;
	LWControl*						m_GlobalBorder1;
	LWControl*						m_GlobalBorder2;

	// Animation tab controls
	LWControl*						m_AnimExportChoice;
	LWControl*						m_AnimationListBox;
	LWControl*						m_AnimNameEdit;
	LWControl*						m_AnimStartEdit;
	LWControl*						m_AnimEndEdit;
	LWControl*						m_AnimFPSEdit;
	LWControl*						m_AnimCyclicChoice;
	LWControl*						m_AnimNewButton;
	LWControl*						m_AnimDeleteButton;
	LWControl*						m_AnimUpButton;
	LWControl*						m_AnimDownButton;
	LWControl*						m_AnimBorder1;
	LWControl*						m_AnimIKSetupButton;

	// Advanced tab controls
	LWControl*						m_PolyPointTypeChoice;
	LWControl*						m_BaseTransFrameEdit;
	LWControl*						m_ExportMeshAsNodeChoice;
	LWControl*						m_MeshNodeExtEdit;

	CLWData*						m_InstData;
	int								m_nSelectedRow;	// The mesh row that has been selected by the user in the Mesh List Box
	int								m_nAnimSelectedRow;	// The anim sequence row selected by the user

protected:
	LWControl*						m_ExportButton;
	LWControl*						m_CloseButton;
	LWControl*						m_ViewNodesButton;
};

#endif // __MESHSELECTOR_H__
