/*	GUIVIEWNODES.CPP
**
**	Supports the CGUIViewNodes functions
**
**	Revision History:
**	March 12, 2002		David Wyand		Created file
*/

//*** Includes
#include "GUIViewNodes.h"

//*** Prototypes
static int NodeListBoxCount( void *userdata );
static char* NodeListBoxName( void *userdata, int index, int column );
static int NodeListBoxColumnWidth( void *userdata, int column );
static void NodeListBoxEvent( LWControl *ectl, void *edata );

static void PanelUserCloseCallback( LWPanelID panel, void *edata );

//*** Global variables
const int NodeListMaxColumns = 4;
char* NodeLBColumnHeadings[] =
{
	"Num","Node Name","Parent","Node Type",(char*)NULL
};
int NodeLBColumnWidths[] =
{
	50,150,150,100
};
char* NodeLBType[] =
{
	"Null","Bone","Mesh",(char*)NULL
};


//*** Constructor
CGUIViewNodes::CGUIViewNodes()
{
	m_InstData = (CLWData*) NULL;
}

//*** Destructor
CGUIViewNodes::~CGUIViewNodes()
{
}

//*** Create the node list
bool CGUIViewNodes::CreateNodeList(CLWData* inst, LWPanelFuncs *panf, LWPanelID panel, int x, int y, int width, int height)
{
	LWPanControlDesc desc;
	static LWValue ival={LWT_INTEGER},ivecval={LWT_VINT},fval={LWT_FLOAT},fvecval={LWT_VFLOAT},sval={LWT_STRING};

	if(inst)
	{
		m_InstData = inst;
	} else
	{
		return false;
	}

	m_Panel = panel;
	m_Panf = panf;

	PAN_SETDATA( panf, panel, this );
	panf->set(panel, PAN_USERCLOSE, PanelUserCloseCallback);

	//*** Build the node list
	m_InstData->BuildNodeList();

	//*** Build the controls
	m_NodeListBox = MULTILIST_CTL(panf, panel, "Node List", width, 10, NodeListBoxName, NodeListBoxCount, NodeListBoxColumnWidth);
	CON_SETEVENT( m_NodeListBox, NodeListBoxEvent, this );

	return true;
}


//************
//*** Functions for panel support
//************

//*** Functions for the Node List Box

//*** Returns the number of rows
static int NodeListBoxCount( void *userdata )
{
	if(userdata)
	{
	 	CGUIViewNodes* data = (CGUIViewNodes*)userdata;

		return (data->m_InstData->GetNumberOfNodes());

	} else
	{
		return 0;
	}
}

//*** Returns the text for a cell [row,column = index,column]
static char* NodeListBoxName( void *userdata, int index, int column )
{
	if(userdata)
	{
 		CGUIViewNodes* data = (CGUIViewNodes*)userdata;

		if(column < NodeListMaxColumns)
		{
			switch(column)
			{
			case 0:
				//*** Num Column
				if(index == -1)
				{
					//*** Return the column title
					return NodeLBColumnHeadings[column];

				} else if(index >= 0 && index < data->m_InstData->GetNumberOfNodes() )
				{
					return data->m_InstData->m_vNodes[index]->m_szNumber;
				}
				return (char*)NULL;
				break;

			case 1:
				//*** Node Name column
				if(index == -1)
				{
					//*** Return the column title
					return NodeLBColumnHeadings[column];

				} else if(index >= 0 && index < data->m_InstData->GetNumberOfNodes() )
				{
					return data->m_InstData->m_vNodes[index]->m_szName;
				}
				return (char*)NULL;
				break;

			case 2:
				//*** Parent Name column
				if(index == -1)
				{
					//*** Return the column title
					return NodeLBColumnHeadings[column];

				} else if(index >= 0 && index < data->m_InstData->GetNumberOfNodes() )
				{
					return data->m_InstData->m_vNodes[index]->m_szParent;
				}
				return (char*)NULL;
				break;

			case 3:
				//*** Type column
				if(index == -1)
				{
					//*** Return the column title
					return NodeLBColumnHeadings[column];

				} else if(index >= 0 && index < data->m_InstData->GetNumberOfNodes() )
				{
					return NodeLBType[data->m_InstData->m_vNodes[index]->m_nType];
				}
				return (char*)NULL;
				break;

			default:
				return (char*)NULL;
				break;
			}

		} else
		{
			return (char*)NULL;
		}
	} else
	{
		return (char*)NULL;
	}
}

//*** Return the width of a given column
static int NodeListBoxColumnWidth( void *userdata, int column )
{
	if(userdata)
	{
 		CGUIViewNodes* data = (CGUIViewNodes*)userdata;

		if(column < NodeListMaxColumns)
		{
			//*** If Layout is asking for a column we want defined...
			return NodeLBColumnWidths[column];
		} else
		{
			//*** ...otherwise return 0 to indicate a column we don't need
			return 0;
		}

	} else
	{
		return 0;
	}
}

static void NodeListBoxEvent( LWControl *ectl, void *edata )
{
	LWPanControlDesc desc;
	LWValue
		ival    = { LWT_INTEGER },
		ivecval = { LWT_VINT },
		fval    = { LWT_FLOAT },
		fvecval = { LWT_VFLOAT },
		sval    = { LWT_STRING };

	CGUIViewNodes* data = (CGUIViewNodes*)edata;
}


//*** Panel user close callback
static void PanelUserCloseCallback( LWPanelID panel, void *edata )
{
	LWPanControlDesc desc;
	LWValue ival    = { LWT_INTEGER }, ivecval = { LWT_VINT }, fval    = { LWT_FLOAT }, fvecval = { LWT_VFLOAT }, sval    = { LWT_STRING };

	CGUIViewNodes* data = (CGUIViewNodes*)edata;

	data->m_InstData->ClearNodeList();

}