/*	LWACODATA.CPP
**
**	Supports the CLWACOData class
**
**	Revision History:
**	April 9, 2002		David Wyand		Created file
*/

//*** Includes
#include "LWGlobal.h"
#include "LWACOData.h"

//************************************************************
//*** Constructor
//************************************************************
CLWACOData::CLWACOData()
{
	m_nTextJustification = 1;
	m_fTextPos = 0.0f;
}

//************************************************************
//*** Destructor
//************************************************************
CLWACOData::~CLWACOData()
{
}

//************************************************************
//*** SAVE()
//*** Saves the material attributes with the object
//************************************************************
int CLWACOData::Save( const LWSaveState *save )
{
	int nVersion = ACO_VERSION;

	//*** Save the version of this plug-in
	LWSAVE_I4( save, (long*) &nVersion, 1 );

	//*** Save out m_nTextJustification
	LWSAVE_I4( save, (long*) &m_nTextJustification, 1 );

	//*** Save out m_fTestPos
	LWSAVE_FP( save, &m_fTextPos, 1 );

	return 1;
}

//************************************************************
//*** LOAD()
//*** Loads the global and object list data
//************************************************************
int CLWACOData::Load( const LWLoadState *load )
{
	int nVersion = 0;

	//*** Load in the version of the plug-in that saved the data
	LWLOAD_I4( load, (long*) &nVersion, 1 );

	//*** Load in m_nTextJustification
	LWLOAD_I4( load, (long*) &m_nTextJustification, 1 );

	//*** Load in m_fTestPos
	LWLOAD_FP( load, &m_fTextPos, 1 );

	return 1;
}
