/*	LWACODATA.H
**
**	Defines the CLWACOData class that contains all of the configuration data for the
**	animation sequence custom object.
**
**	Revision History:
**	April 9, 2002		David Wyand		Created file
*/

#ifndef __LWACODATA_H__
#define __LWACODATA_H__

//*** Includes
#include <lwsurf.h>

//*** Definitions
#define ACO_VERSION			1
#define ID_ACOVERS  LWID_( 'V','E','R','S' )

//*** Globals
static LWBlockIdent idACOVersion[] = {
	ID_ACOVERS, "Version",
	0,0
};

//*** Definition of the CLWESData class
class CLWACOData
{
	//*** Functions
public:
	CLWACOData();
	virtual ~CLWACOData();

	int Save( const LWSaveState *save );
	int Load( const LWLoadState *load );

	//*** Variables
public:
	int				m_nTextJustification;	// Justification of text: 0=left, 1=centre, 2=right
	float			m_fTextPos;				// Position of text from centre of null
};


#endif // __LWACODATA_H__
