/*	LWESDATA.CPP
**
**	Supports the CLWESData class
**
**	Revision History:
**	March 29, 2002		David Wyand		Created file
*/

//*** Includes
#include "dtsSDK/DTSShape.h"
#include "LWGlobal.h"
#include "LWESData.h"

//************************************************************
//*** Constructor
//************************************************************
CLWESData::CLWESData()
{
	m_nTransparentType = 0;
	m_nNoMipMap = 0;
	m_nMipMapZeroBorder = 0;
	m_ID = (LWSurfaceID) NULL;

	m_vList.push_back(this);
}

//************************************************************
//*** Destructor
//************************************************************
CLWESData::~CLWESData()
{
	vector<CLWESData*>::iterator itor;

	//*** Remove this from the list
	for(itor = m_vList.begin(); itor != m_vList.end(); ++itor)
	{
		if((*itor) == this)
		{
			(*itor) = NULL;
		}
	}
}

//************************************************************
//*** UPDATEMATERIALFLAGS()
//*** Adds to a material's flag member according to the shader's settings
//************************************************************
void CLWESData::UpdateMaterialFlags(int &flag)
{
	//*** Additive transparency
	if(m_nTransparentType == 1)
	{
		flag |= DTS::Material::Additive;
	}

	//*** Subtractive transparency
	if(m_nTransparentType == 2)
	{
		flag |= DTS::Material::Subtractive;
	}

}

//************************************************************
//*** SAVE()
//*** Saves the material attributes with the object
//************************************************************
int CLWESData::Save( const LWSaveState *save )
{
	int nVersion = EXSH_VERSION;

	//*** Save the version of this plug-in
	LWSAVE_I4( save, (long*) &nVersion, 1 );

	//*** Save out m_nTransparentType
	LWSAVE_I4( save, (long*) &m_nTransparentType, 1 );

	//*** Save out m_nNoMipMap
	LWSAVE_I4( save, (long*) &m_nNoMipMap, 1 );

	//*** Save out m_nMipMapZeroBorder
	LWSAVE_I4( save, (long*) &m_nMipMapZeroBorder, 1 );

	return 1;
}

//************************************************************
//*** LOAD()
//*** Loads the global and object list data
//************************************************************
int CLWESData::Load( const LWLoadState *load )
{
	int nVersion = 0;

	//*** Load in the version of the plug-in that saved the data
	LWLOAD_I4( load, (long*) &nVersion, 1 );

	//*** Load in m_nTransparentType
	LWLOAD_I4( load, (long*) &m_nTransparentType, 1 );

	//*** Load in m_nNoMipMap
	LWLOAD_I4( load, (long*) &m_nNoMipMap, 1 );

	//*** Load in m_nMipMapZeroBorder
	LWLOAD_I4( load, (long*) &m_nMipMapZeroBorder, 1 );

	return 1;
}

//************************************************************
//*** FINDBYSURFACE()
//*** Finds the CLWESData class in the global list by LW surface ID
//************************************************************
CLWESData* CLWESData::FindBySurface(LWSurfaceID id)
{
	vector<CLWESData*>::iterator itor;

	//*** Find the CLWESData class that matches the user given LW surface ID
	for(itor = m_vList.begin(); itor != m_vList.end(); ++itor)
	{
		if((*itor) != NULL)
		{
			if((*itor)->m_ID == id)
			{
				return (*itor);
			}
		}
	}

	return (CLWESData*)NULL;
}

vector<CLWESData*> CLWESData::m_vList;
