/*	LWESDATA.H
**
**	Defines the CLWESData class that contains all of the configuration data for the
**	special shader.
**
**	Revision History:
**	March 29, 2002		David Wyand		Created file
*/

#ifndef __LWESDATA_H__
#define __LWESDATA_H__

//*** Includes
#include <vector>
#include <lwsurf.h>

//*** Definitions
#define EXSH_VERSION			1
#define ID_EXSHVERS  LWID_( 'V','E','R','S' )

//*** Globals
static LWBlockIdent idEXSHVersion[] = {
	ID_EXSHVERS, "Version",
	0,0
};

using namespace std;

//*** Definition of the CLWESData class
class CLWESData
{
	//*** Functions
public:
	CLWESData();
	virtual ~CLWESData();

	void UpdateMaterialFlags(int &flag);	// Updates a material flag member based on shader settings

	int Save( const LWSaveState *save );
	int Load( const LWLoadState *load );

	static CLWESData* FindBySurface(LWSurfaceID id);	// Find within m_vList by LW surface ID

	//*** Variables
public:
	LWSurfaceID		m_ID;					// The LW surface ID that the shader is attached to
	int				m_nTransparentType;		// Type of transparency: 0=normal, 1=additive, 2=subtractive
	int				m_nNoMipMap;			// Disable mip mapping: 0=false, 1=true
	int				m_nMipMapZeroBorder;	// No border on mip map: 0=false, 1=true

	static vector<CLWESData*>	m_vList;	// Static list holding pointers to all defined CLWESData classes
};


#endif // __LWESDATA_H__
