/*	LWGLOBAL.CPP
**
**	Supports the CLWGlobal class
**
**	Revision History:
**	February 15, 2002	David Wyand		Created file
**	April 3, 2002		David Wyand		Added Bone Info global
**	April 24, 2002		David Wyand		Added Channel Info and Animation Envelope globals
**	April 24, 2002		David Wyand		Added Evaluate (Layout Command) global
*/

//*** Includes
#include <string.h>
#include "LWGlobal.h"

CLWGlobal::CLWGlobal()
{
	global = (GlobalFunc*)NULL;
	msg = (LWMessageFuncs*)NULL;
	iteminfo = (LWItemInfo*)NULL;
	scninfo = (LWSceneInfo*)NULL;
	objinfo = (LWObjectInfo*)NULL;
	ui = (LWInterfaceInfo*)NULL;
	surff = (LWSurfaceFuncs*)NULL;
	txtrf = (LWTextureFuncs*)NULL;
	imglist = (LWImageList*)NULL;
	monf = (LWLMonFuncs*)NULL;
	timeinfo = (LWTimeInfo*)NULL;
	chinfo = (LWChannelInfo*)NULL;
	envfunc = (LWEnvelopeFuncs *)NULL;
	evaluate = (LWCommandFunc*)NULL;
}

bool CLWGlobal::Initialize(GlobalFunc *pglobal)
{
	//*** Get some LW globals to access the scene
	if(global == NULL)
	{
		global = pglobal;

		//*** Initialize the common gloals
		msg = (LWMessageFuncs *)(*global)( LWMESSAGEFUNCS_GLOBAL, GFUSE_TRANSIENT );
		surff = (LWSurfaceFuncs*)(*global)(LWSURFACEFUNCS_GLOBAL, GFUSE_TRANSIENT );
		txtrf = (LWTextureFuncs*)(*global)( LWTEXTUREFUNCS_GLOBAL, GFUSE_TRANSIENT );
		imglist = (LWImageList*)(*global)( LWIMAGELIST_GLOBAL, GFUSE_TRANSIENT );

		if ( !msg || !surff || !txtrf || !imglist )
		{
			return false;
		}

		//*** Find out what we are running under: Modeler or Layout
		unsigned long sysid;
		sysid = ( unsigned long ) (*global)( LWSYSTEMID_GLOBAL, GFUSE_TRANSIENT );

		//*** Initialize Layout specific globals
		if((sysid & LWSYS_TYPEBITS) == LWSYS_LAYOUT)
		{
			iteminfo = (LWItemInfo*)(*global)( LWITEMINFO_GLOBAL, GFUSE_TRANSIENT );
			scninfo = (LWSceneInfo*)(*global)( LWSCENEINFO_GLOBAL, GFUSE_TRANSIENT );
			objinfo = (LWObjectInfo*)(*global)( LWOBJECTINFO_GLOBAL, GFUSE_TRANSIENT );
			boneinfo = (LWBoneInfo*)(*global)( LWBONEINFO_GLOBAL, GFUSE_TRANSIENT );
			ui = (LWInterfaceInfo*)(*global)( LWINTERFACEINFO_GLOBAL, GFUSE_TRANSIENT );
			monf = (LWLMonFuncs*)(*global)( LWLMONFUNCS_GLOBAL, GFUSE_TRANSIENT );
			timeinfo = (LWTimeInfo*)(*global)( LWTIMEINFO_GLOBAL, GFUSE_TRANSIENT );
			chinfo = (LWChannelInfo*)(*global)( LWCHANNELINFO_GLOBAL, GFUSE_TRANSIENT );
			envfunc = (LWEnvelopeFuncs *)(*global)( LWENVELOPEFUNCS_GLOBAL, GFUSE_TRANSIENT );
			evaluate = (LWCommandFunc*)(*global)( LWCOMMANDFUNC_GLOBAL, GFUSE_TRANSIENT );

			if ( !iteminfo || !scninfo || !objinfo || !boneinfo || !ui || !monf || !timeinfo || !chinfo || !envfunc || !evaluate)
			{
				return false;
			}
		}
	}

	return true;
}

int CLWGlobal::GetObjectCount()
{
	LWItemID id;
	int count = 0;

	id = iteminfo->first( LWI_OBJECT, NULL );
	while ( id )
	{
		++count;
		id = iteminfo->next( id );
	}

	return (count);
}

LWItemID CLWGlobal::GetObjectByNum(int num)
{
	LWItemID id;
	int count = 0;

	id = iteminfo->first( LWI_OBJECT, NULL );
	while ( id )
	{
		++count;
		//*** num is zero based, but we're starting our count at 1
		if(count == (num+1) )
		{
			return (id);
		}

		id = iteminfo->next( id );
	}

	return LWITEM_NULL;
}

//*** Functions for a Layout monitor
LWLMonID CLWGlobal::LayoutMonitorInit(char* title, unsigned int flags, const char *histfile, unsigned int total, const char *msg)
{
	if(mon != NULL)
	{
		return (LWLMonID)NULL;
	}

	mon = monf->create();
	if ( mon )
	{
		monf->setup( mon, title, flags, histfile );
		monf->init( mon, total, msg );
		return mon;
	}

	return (LWLMonID)NULL;
}

void CLWGlobal::LayoutMonitorStep(unsigned int step, const char *msg)
{
	if(mon)
	{
		monf->step( mon, step, msg );
	}
}

void CLWGlobal::LayoutMonitorDone()
{
	if(mon)
	{
		monf->done( mon );
		monf->destroy( mon );
		mon = (LWLMonID)NULL;
	}
}

//************************************************************
//*** FINDENV()
//*** Finds a channel, and if found, returns the envelope for it
//************************************************************
LWEnvelopeID CLWGlobal::findEnv( LWChanGroupID group, char *name )
{
	LWChannelID chan;

	chan = CLWGlobal::chinfo->nextChannel( group, NULL );
	while ( chan ) {
		if ( !strcmp( CLWGlobal::chinfo->channelName( chan ), name ))
		{
			return CLWGlobal::chinfo->channelEnvelope( chan );
		}

		chan = CLWGlobal::chinfo->nextChannel( group, chan );
	}
	return NULL;
}

//CLWGlobal MyCLWGlobalInstance();
GlobalFunc* CLWGlobal::global = (GlobalFunc*)NULL;
LWMessageFuncs* CLWGlobal::msg = (LWMessageFuncs*)NULL;
LWItemInfo* CLWGlobal::iteminfo = (LWItemInfo*)NULL;
LWSceneInfo* CLWGlobal::scninfo = (LWSceneInfo*)NULL;
LWObjectInfo* CLWGlobal::objinfo = (LWObjectInfo*)NULL;
LWBoneInfo* CLWGlobal::boneinfo = (LWBoneInfo*)NULL;
LWInterfaceInfo* CLWGlobal::ui = (LWInterfaceInfo*)NULL;
LWSurfaceFuncs* CLWGlobal::surff = (LWSurfaceFuncs*)NULL;
LWTextureFuncs* CLWGlobal::txtrf = (LWTextureFuncs*)NULL;
LWImageList* CLWGlobal::imglist = (LWImageList*)NULL;
LWLMonFuncs* CLWGlobal::monf = (LWLMonFuncs*)NULL;
LWLMonID CLWGlobal::mon = (LWLMonID)NULL;
LWTimeInfo* CLWGlobal::timeinfo = (LWTimeInfo*)NULL;
LWChannelInfo* CLWGlobal::chinfo = (LWChannelInfo*)NULL;
LWEnvelopeFuncs* CLWGlobal::envfunc = (LWEnvelopeFuncs*)NULL;
LWCommandFunc* CLWGlobal::evaluate = (LWCommandFunc*)NULL;
