/*	LWGLOBAL.H
**
**	Defines the CLWGlobal class that contains pointers to all of the LW global functions
**
**	Revision History:
**	February 15, 2002	David Wyand		Created file
**	April 3, 2002		David Wyand		Added Bone Info global
**	April 24, 2002		David Wyand		Added Channel Info and Animation Envelope globals
**	April 24, 2002		David Wyand		Added Evaluate (Layout Command) global
*/

#ifndef __LWGLOBAL_H__
#define __LWGLOBAL_H__

//*** Includes
#include <lwserver.h>
#include <lwhost.h>
#include <lwrender.h>
#include <lwsurf.h>
#include <lwimage.h>
#include <lwmonitor.h>
#include <lwenvel.h>

//*** Defines
#define LWCOMMANDFUNC_GLOBAL "LW Command Interface"
//typedef int ( *LWCommandFunc )( const char *cmd );
typedef int LWCommandFunc( const char *cmd );

//*** Define the CLWGlobal class
class CLWGlobal
{
	//*** Functions
public:
	CLWGlobal();

	static bool Initialize(GlobalFunc *pglobal);
	static int GetObjectCount();
	static LWItemID GetObjectByNum(int num);

	static LWLMonID LayoutMonitorInit(char* title, unsigned int flags, const char *histfile, unsigned int total, const char *msg);
	static void LayoutMonitorStep(unsigned int step, const char *msg);
	static void LayoutMonitorDone();

	static char* GetPanelTitle() {return "Torque Engine DTS Exporter [Build 17-05-02 By David Wyand]";}

	static LWEnvelopeID findEnv( LWChanGroupID group, char *name );

	//*** Variables
public:
	static GlobalFunc		*global;
	static LWMessageFuncs	*msg;
	static LWItemInfo		*iteminfo;
	static LWSceneInfo		*scninfo;
	static LWObjectInfo		*objinfo;
	static LWBoneInfo		*boneinfo;
	static LWInterfaceInfo	*ui;
	static LWSurfaceFuncs	*surff;
	static LWTextureFuncs	*txtrf;
	static LWImageList		*imglist;
	static LWLMonFuncs		*monf;
	static LWTimeInfo		*timeinfo;
	static LWChannelInfo	*chinfo;
	static LWEnvelopeFuncs	*envfunc;
	static LWCommandFunc	*evaluate;

	static LWLMonID			mon;
};


#endif // __LWGLOBAL_H__
