/*	LWSERVERRECORD.CPP
**
**	Defines the standard server record for LightWave's plug-in interface
**
**	Revision History:
**	February 29, 2001	David Wyand		Created file
*/

//*** Includes
#include <lwserver.h>			// all plug-ins need this
#include <lwmaster.h>			// for the LayoutMaster class
#include <lwshader.h>			// for shader functions
#include <lwcustobj.h>			// for custom objects
#include <lwmotion.h>
#include "main.h"
#include "LWExporterShader.h"
#include "LWAnimCustomObj.h"
#include "LWIKItemMotion.h"

/*
======================================================================
This is the server description.  LightWave looks at this first to
determine what plug-ins the file contains.  It lists each plug-in's
class and internal name, along with a pointer to the activation
function.  You can optionally add a user name, or more than one in
different languages, if you like.
====================================================================== */
extern "C"
{
	ServerRecord ServerDesc[] = {
		{ LWMASTER_HCLASS, "TorqueDTSExporter", (ActivateFunc *) ExporterActivate, (ServerTagInfo *) NULL},
		{ LWMASTER_ICLASS, "TorqueDTSExporter", ExporterInterface, (ServerTagInfo *) NULL},
		{ LWSHADER_HCLASS, "TorqueDTS_MaterialAttributes", (ActivateFunc *) ExpShaderActivate, (ServerTagInfo *) NULL},
		{ LWSHADER_ICLASS, "TorqueDTS_MaterialAttributes", ExpShaderInterface, (ServerTagInfo *) NULL},
		{ LWCUSTOMOBJ_HCLASS, "TorqueDTS_AnimSequence", (ActivateFunc *) AnimCustObjActivate, (ServerTagInfo *) NULL},
		{ LWCUSTOMOBJ_ICLASS, "TorqueDTS_AnimSequence", AnimCustObjInterface, (ServerTagInfo *) NULL},
		{ LWITEMMOTION_HCLASS, "TorqueDTS_IKChannelCreator", (ActivateFunc *) IKItemMotionActivate, (ServerTagInfo *) NULL},
		{ LWITEMMOTION_ICLASS, "TorqueDTS_IKChannelCreator", IKItemMotionInterface, (ServerTagInfo *) NULL},
		{ (const char *) NULL }
	};
}
