/*	MAIN.CPP
**
**	This file sets up the LW plugin interface
**
**	TODO: Rename this file and its include to something more appropriate as there are
**	now multiple plug-ins defined in this workspace.
**
**	Revision History:
**	February 11, 2001	David Wyand		Created file
**	March 29, 2002		David Wyand		Changed the Activate and Interface function names to
**										ExporterActivate and ExporterInterface respectively.
*/

//*** Includes
#include <lwserver.h>			// all plug-ins need this
#include <lwmaster.h>			// for the LayoutMaster class
#include <lwpanel.h>			// for "classic" panels
#include <lwhost.h>				// for the LWMessageFuncs global
#include <stdio.h>				// for NULL #define
#include <stdlib.h>
#include "LWGlobal.h"
#include "LWData.h"
#include "GUIMeshSelector.h"
#include "main.h"

//*** Global variables
GlobalFunc *g_Global;				// Pointer to all global functions
//LWMessageFuncs *msg;			//* the message functions
LWPanelFuncs *panf;				//* the panel functions
LWPanelID panel = 0;				//* the panel
LWControl *ctl;					//* a control on the panel
LWPanControlDesc desc;			//* used by macros in lwpanel.h
LWValue sval = { LWT_STRING };	//*  read lwpanel.h to see how
char edit[ 80 ] =				//* string for the edit control
   "This is an edit field.";
char CreateErrText[]="Only a single instance of the Torque DTS Exporter may be included in a scene.";

//*** Prototypes
extern "C"
{
//XCALL_(static int)		ExporterActivate( long version, GlobalFunc *global, LWMasterHandler *local, void *serverData );
XCALL_(const char*)		Describe(LWInstance);
XCALL_(LWInstance)		Create(void *,void *,LWError *);
XCALL_(void)			Destroy(LWInstance);
XCALL_(LWError)			Copy(LWInstance,LWInstance);
XCALL_(LWError)			Load(LWInstance,const LWLoadState *);
XCALL_(LWError)			Save(LWInstance,const LWSaveState *);
XCALL_(const LWItemID*)	UseItems(LWInstance);
XCALL_(void)			ChangeID(LWInstance, const LWItemID *);
XCALL_(double)			Event(LWInstance,const LWMasterAccess *);
XCALL_(unsigned int)	Flags(LWInstance);
//XCALL_(static int)		ExporterInterface(long version, GlobalFunc *global, void *local, void *serverData);
XCALL_(LWError)			Options(LWInstance inst);
}

//************************************************************
//*** ACTIVATE()
//*** Layout calls this when the user selects the plugin from the list of
//*** master handlers in Layout's interface.  Scene->Master Plug-ins->Add Master or Scene Plug-in
//************************************************************
extern "C"
{
//************
XCALL_(int) ExporterActivate( long version, GlobalFunc *global, LWMasterHandler *local, void *serverData )
{
	//*** Check that Layout is of the correct version
	if ( version != LWMASTER_VERSION )
		return AFUNC_BADVERSION;

	//*** Pass along pointers to the different plug-in functions (generic)
	if(local->inst)
	{
		local->inst->create     = Create;
		local->inst->destroy    = Destroy;
		local->inst->load       = Load;
		local->inst->save       = Save;
		local->inst->copy       = Copy;
		local->inst->descln     = Describe;
	}

	//*** Pass along pointers to the different plug-in functions for object changes (generic)
	if(local->item)
	{
		local->item->useItems   = UseItems;
		local->item->changeID   = ChangeID;
	}

	//*** Pass along pointers to the different plug-in functions (master handler)
	local->event            = Event;
	local->flags            = Flags;

	//*** Get the message and panels functions
	//msg = (LWMessageFuncs *) (*global)( LWMESSAGEFUNCS_GLOBAL, GFUSE_TRANSIENT );
	panf = (LWPanelFuncs *) (*global)( LWPANELFUNCS_GLOBAL, GFUSE_TRANSIENT );
//	if ( !msg || !panf )
	if ( !panf )
		return AFUNC_BADGLOBAL;

	//*** Initalize the CLWGlobal static class
	if( CLWGlobal::Initialize(global) == false)
	{
		return AFUNC_BADGLOBAL;
	}

	g_Global = global;

	return AFUNC_OK;
}

//************************************************************
//*** CREATE()
//*** Called when an instance of the plug-in has been created
//************************************************************
XCALL_(LWInstance) Create(void *priv,void *context,LWError *err)
{
	CLWData*	mydata;

	//*** Check if the user already has this plug-in added to the Master Handler
	//*** plug-in list.
	if(CLWData::FindFirstInstance() != (CLWData*)NULL)
	{
		*err = CreateErrText;
		return NULL;
	}

	mydata = new CLWData;

	return(mydata);
}

//************************************************************
//*** DESTROY()
//*** Called when an instance of the plug-in has been destroyed
//************************************************************
XCALL_(void) Destroy(LWInstance inst)
{
	CLWData*	mydata;

	mydata = (CLWData*) inst;

	if(mydata)
	{
		delete mydata;
	}

}

//************************************************************
//*** COPY()
//*** Called when an instance of the plug-in needs to be copied
//************************************************************
XCALL_(LWError) Copy(LWInstance d1,LWInstance d2)
{
    return((LWError) NULL);
}

//************************************************************
//*** LOAD()
//*** Called to load in the plug-in data from a scene
//************************************************************
XCALL_(LWError) Load(LWInstance inst,const LWLoadState *lState)
{
	CLWData*	mydata;

	mydata = (CLWData*) inst;

	mydata->Load(lState);

    return((LWError) NULL);
}

//************************************************************
//*** SAVE()
//*** Called to save the plug-in data to a scene
//************************************************************
XCALL_(LWError) Save(LWInstance inst,const LWSaveState *sState)
{
	CLWData*	mydata;

	mydata = (CLWData*) inst;

	mydata->Save(sState);

    return((LWError) NULL);
}

//************************************************************
//*** DESCRIBE()
//*** Called when Layout needs to display the name of the plug-in to the user
//************************************************************
XCALL_(const char *) Describe(LWInstance inst)
{
    return("LW to DTS Exporter");
}

//************************************************************
//*** LWITEMID()
//*** Called when Layout needs to know what items this plug-in instance rely on.
//************************************************************
XCALL_(const LWItemID*)	UseItems(LWInstance inst)
{
	return((LWItemID*) LWITEM_ALL );
}

//************************************************************
//*** CHANGEID()
//*** Called when an item's ID changes for some reason.
//************************************************************
XCALL_(void) ChangeID(LWInstance inst, const LWItemID *id)
{
	CLWData* instData = (CLWData*) inst;

	LWItemID oldid, newid;
	int count = 0;

	oldid = id[count];
	while(oldid != NULL)
	{
		++count;
		newid = id[count];

		//*** Handle the change...
		if(newid == 0)	//*** Check if object has been deleted
		{
			instData->DeleteObject(oldid);

		} else if(newid != oldid) //*** Check if object ID has changed
		{
			instData->ChangeObjectID(oldid, newid);
		}

		//*** Continue with the next one...
		++count;
		oldid = id[count];
	}
}

//************************************************************
//*** EVENT()
//*** Called by Layout to react to an event
//************************************************************
XCALL_(double) Event(LWInstance inst,const LWMasterAccess *ma)
{
	return((double)0.0);
}

//************************************************************
//*** FLAGS()
//*** Called to tell layout what types of events we should be sent.
//************************************************************
XCALL_(unsigned int) Flags(LWInstance inst)
{
	return(0);
}


} // extern "C"

//************************************************************
//*** INTERFACE()
//*** Layout calls this when it needs info about the GUI
//************************************************************
extern "C"
{
XCALL_(int) ExporterInterface(long version, GlobalFunc *global, void *local, void *serverData )
{
	LWInterface* mylocal;
	
	if ( version != LWINTERFACE_VERSION )
		return AFUNC_BADVERSION;

	mylocal = (LWInterface*) local;

	mylocal->panel   = NULL;
	mylocal->options = Options;
	mylocal->command = 0; // (NULL);

	if(panf)
	{
		panf->globalFun = global;
	}

	return(AFUNC_OK);
}

//************************************************************
//*** OPTIONS()
//*** Layout calls this when the user opens the GUI
//************************************************************
XCALL_(LWError) Options(LWInstance inst)
{
	CGUIMeshSelector	meshselect;
	CLWData* instData = (CLWData*) inst;

	//panel = get_panel();
	//if ( !panel ) return AFUNC_BADGLOBAL;

	//*** Define the panel
	if( !( panel = PAN_CREATE( panf, CLWGlobal::GetPanelTitle() )))
	{
		/*
		if(msg)
		{
			msg->info("Cannot open the user interface!","");
		}*/

		CLWGlobal::msg->info("Cannot open the user interface!","");
		return 0;
	}

	//*** Open the panel
	if(panel)
	{
		//*** Refresh the list of objects to add any new ones
		instData->RefreshObjectList();

		//*** Refresh the object's names as they may have changed since the last
		//*** time the plug-in was opened
		instData->RefreshObjectNames();

		//*** Create all of the controls
		meshselect.CreateMeshSelector(instData, panf, panel, 0, 0, 450, 200);

		//*** Display the panel
		panf->open( panel, PANF_BLOCKING | PANF_NOBUTT | PANF_FRAME );

		PAN_KILL( panf, panel );
	}

	return(AFUNC_OK);
}

} // extern "C"

